<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Vault;

class AccountCountError extends \Google\Model
{
  protected $accountType = UserInfo::class;
  protected $accountDataType = '';
  public $account;
  /**
   * @var string
   */
  public $errorType;

  /**
   * @param UserInfo
   */
  public function setAccount(UserInfo $account)
  {
    $this->account = $account;
  }
  /**
   * @return UserInfo
   */
  public function getAccount()
  {
    return $this->account;
  }
  /**
   * @param string
   */
  public function setErrorType($errorType)
  {
    $this->errorType = $errorType;
  }
  /**
   * @return string
   */
  public function getErrorType()
  {
    return $this->errorType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AccountCountError::class, 'Google_Service_Vault_AccountCountError');
